data{
    int n;
    vector[n] x1;
    vector[n] x2;
    vector[n] y;
}
parameters{
    real beta0;
    vector[2] beta;
    real<lower=0,upper=100> sigma;
}
transformed parameters{
    vector[n] mu;
    {
        for(i in 1:n){
            mu[i] = beta0 + beta[1]*x1[i] + beta[2]*x2[i] ;
        }
    }
}
model{
    // Likelihood
    for(i in 1:n){
        y[i] ~ normal(mu[i],sigma);
    }
    // Priors
    beta0 ~ normal(0, 100);
    for(i in 1:2){
        beta[i] ~ normal(0, 100);
    }
}
generated quantities{
    //  log-likelihood
    vector[n] log_likelihood;
  {
    for(i in 1:n){
      log_likelihood[i] = normal_lpdf(y[i] | mu[i], sigma);
    }
  }
  real log_lik;
  {
    log_lik = sum(log_likelihood);
  }
}